//%attributes = {"publishedSql":true}
C_LONGINT:C283($0; $error)  //error
C_POINTER:C301($1; $pict_BarCode)  //pointer to barcode picture
C_TEXT:C284($2)  //text to encode
C_TEXT:C284($string_to_encode)  //string for retrieving
C_PICTURE:C286($black_pixel)  //Black pixel out of library
C_PICTURE:C286($black_pixel)  //White pixel out of library
C_LONGINT:C283($modulo; $Checksum; $Checkdigit)  // for computing control character
C_LONGINT:C283($found)  //array index
C_LONGINT:C283($j; $i; $digit)  //loop counters
_O_C_STRING:C293(3; $codesystem)  //system code (country of origin)
_O_ARRAY STRING:C218(7; $ta_CaracteSet; 20)  //standard mapping

$pict_BarCode:=$1
$string_to_encode:=$2

$pict_BarCode->:=$pict_BarCode->*0

If (Count parameters:C259=3)
	//ISBN -> books -> 978
	//ISSN -> magazines -> 977
	//ISSM -> music  -> 979
	$codesystem:=$3  //ISBN  = 978 ou ISSN =977 ou ISSM = 979
Else 
	$codesystem:="978"  //ISBN by defaut
End if 

$string_length:=Length:C16($string_to_encode)

Case of 
	: ($string_length=9)
	: ($string_length=10)
		$string_to_encode:=Substring:C12($string_to_encode; 1; 9)
	Else 
		_info_ ALERT("Entry error, "+Char:C90(13)+"you need to enter a nine-character long string (for example 0-245-50330 ")
		$error:=-1
End case 


If ($error=0)
	
	LIST TO ARRAY:C288("Characters_set_13"; $ta_CaracteSet)  //loading binary symbols
	
	If (Size of array:C274($ta_CaracteSet)=0)
		_info_ ALERT("Choice list resource error...")
		$error:=1
	End if 
	
	If ($error=0)
		
		_O_ARRAY STRING:C218(7; $ta_left_hand; 10)
		_O_ARRAY STRING:C218(7; $ta_right_hand; 10)
		
		GET PICTURE FROM LIBRARY:C565(1000; $black_pixel)
		GET PICTURE FROM LIBRARY:C565(1001; $white_pixel)
		
		If (Picture size:C356($black_pixel)=0) & (Picture size:C356($white_pixel)=0)
			_info_ ALERT("Picture resource error...")
			$error:=2
		End if 
		
	End if 
	
	If ($error=0)
		
		$image:=$white_pixel*+17
		
		$image2:=$white_pixel*+17
		
		For ($i; 1; 10)
			$ta_left_hand{$i}:=$ta_CaracteSet{$i}
			$ta_right_hand{$i}:=$ta_CaracteSet{$i+10}
		End for 
		
		//left guard bars -> 101
		$image:=$image+$black_pixel+$white_pixel+$black_pixel
		$image2:=$image2+$black_pixel+$white_pixel+$black_pixel
		
		$string_to_encode:=$codesystem+$string_to_encode
		
		//computing control character for barcode
		$Checksum:=0
		For ($i; 12; 1; -1)
			If (($i/2)#($i\2))
				$Checksum:=$Checksum+(Num:C11($string_to_encode[[$i]]))
			Else 
				$Checksum:=$Checksum+(Num:C11($string_to_encode[[$i]])*3)
			End if 
		End for 
		
		$check_S:=String:C10($Checksum)
		$Checkdigit:=10-Num:C11(Substring:C12($check_S; Length:C16($check_S)))  //10-extract the last number    
		
		$string_to_encode:=$string_to_encode+String:C10($Checkdigit)
		
		$codealpha:=Substring:C12($string_to_encode; 2)
		//Left Hand bars
		For ($i; 2; 7; 1)
			$digit:=Num:C11($codealpha[[$i]])+1
			If (($i\2)#($i/2))  //-> ODD PARITY
				For ($rang; 1; 7; 1)
					If ($ta_left_hand{$digit}[[$rang]]="0")
						$image:=$image+$white_pixel
					Else 
						$image:=$image+$black_pixel
					End if 
					$image2:=$image2+$white_pixel
				End for 
			Else   //-> EVEN PARITY
				For ($rang; 7; 1; -1)
					If ($ta_left_hand{$digit}[[$rang]]="0")
						$image:=$image+$black_pixel
					Else 
						$image:=$image+$white_pixel
					End if 
					$image2:=$image2+$white_pixel
				End for 
			End if 
			
		End for 
		
		//center guard bars -> 01010
		$image:=$image+$white_pixel+$black_pixel+$white_pixel+$black_pixel+$white_pixel
		$image2:=$image2+$white_pixel+$black_pixel+$white_pixel+$black_pixel+$white_pixel
		
		//Right Hand bars
		For ($i; 7; 12; 1)
			$digit:=Num:C11($codealpha[[$i]])+1
			For ($rang; 1; 7; 1)
				If ($ta_right_hand{$digit}[[$rang]]="0")
					$image:=$image+$white_pixel
				Else 
					$image:=$image+$black_pixel
				End if 
				$image2:=$image2+$white_pixel
			End for 
		End for 
		
		//right guard bars -> 101
		$image:=$image+$black_pixel+$white_pixel+$black_pixel
		$image2:=$image2+$black_pixel+$white_pixel+$black_pixel
		
		$image:=$image*|40  //vertical increase 40%
		$image2:=$image2*|5  //vertical increase 5%
		$image:=$image/$image2  //placing image 2 below image 1      
		//building text using 4D CHART
		$text_low:=Substring:C12($codesystem; 1; 1)+(" "*5)+Substring:C12($string_to_encode; 2; 6)+(" "*5)+Substring:C12($string_to_encode; 8)+(" "*5)
		$chart:=0  // v19: CT New offscreen area 
		$text:=0  // v19: CT Draw text ($chart;0;0;120;12;$text_low)
		// v19: CT SET TEXT ATTRIBUTES ($chart;$text;// v19: CT Font number ("Helvetica");10;Plain;// v19: CT Index to color (16);0)
		$image_text:=0  // v19: CT Area to picture ($chart;$text)  //chart text to image 
		// v19: CT DELETE OFFSCREEN AREA ($chart)  //clearing memory
		$image_text:=($image_text/41)  //vertical move 
		//$image:=$image & $image_text // v19: //superimposing pictures
		
		$pict_BarCode->:=$image  //returning final picture    
		
	End if 
	
End if 
